#ifndef BFTAPE_H
#define BFTAPE_H
//----------
//Element einer doppelt verketteten Liste, (hier für ein Brainfuck-Tape)
typedef struct tape{
	//Wert in der Zelle
	char cell;
	//Pointer auf nächstes Element des Tapes (NULL, wenn es noch kein nächstes Element gibt)
	struct tape* next;
	//Pointer auf vorheriges Element des Tapes (NULL, wenn es noch keins gibt)
	struct tape* prev;
	
}TAPE;
//----------
//Reserviert Speicher für eine Zelle und setzt die Variablen auf den Standardwert
//Parameter: Vorherige und nächste Tapezelle in der Liste
//Gibt NULL zurück, wenn kein Speicher reserviert werden konnte
TAPE* createTapeCell(TAPE* prev, TAPE* next);
//----------
//Gibt den Speicher für das komplette Tape wieder frei
void deleteTape(TAPE*);
//----------
//Funktionen, um auf das vorherige/nächste Element des Tape zuzugreifen
//Existiert noch keins, wird es erstellt
TAPE* getNextCell(TAPE*);
TAPE* getPrevCell(TAPE*);
//----------
#endif
