#include <stdio.h>
#include <stdlib.h>
#include "bftape.h"
#include "extstring.h"

char* get_subloop(char* source, extstring* target);

TAPE* celltape = NULL;

void bf_interprete(char *code){
	char *pos = code;
	int i;
	if(celltape == NULL){
		celltape = createTapeCell(NULL, NULL);
		if(celltape == NULL){
			fprintf(stderr, "Fehler beim Speicherreservieren für das Tape\n");	
		}
	}
	while(*pos!=0){
		switch(*pos){
			case '+':
				celltape->cell++;
				break;
			case '-':
				celltape->cell--;
				break;
			case '<':
				celltape = getPrevCell(celltape);
				break;
			case '>':
				celltape = getNextCell(celltape);
				break;
			case '.':
				putchar(celltape->cell);
				break;
			case ',':
				celltape->cell = (char)getchar();
				break;
			case '[':{
				extstring substr = createExtstring(500);
				//Speicherplatzrevervierung hat geklappt?
				if(substr.string == NULL)exit(1);
				pos = get_subloop(pos+1, &substr);
				while(celltape->cell){
					bf_interprete(substr.string);
				}
				destroyExtstring(&substr);
				break;
			}
			case ']':
				fprintf(stderr, "Syntaxfehler: überflüssiges Schleifenende\n");
				exit(1);
				break;
				
		}
		pos++;
	}
}

/*Schneidet den String innerhalb einer Schleife aus
 * Parameter source: Quellstring
 * Parameter target: Zielstring
 * Rückgabewert: Zeiger auf die Position des Quellstrings nach der ausgeschnittenen Schleife*/
char* get_subloop(char* source, extstring* target){
	//Variable die speichert, wie viele offene Klammern es gibt
	int nopen=1;
	while(nopen>0){
		//Wenn das schon das Ende des Strings ist, liegt ein Syntaxfehler vor
		if(*source==0){
			fprintf(stderr, "Syntaxfehler: Schließende Klammer fehlt");
			exit(1);
		}
		//Zähle offene/geschlossene Klammern
		if(*source=='[')nopen++;
		else if(*source==']')if(--nopen==0)break;
		appendChar(target, *source);
		source++;
	}
	//Gebe zurück: Quellstring an der Stelle der geschlossenen Klammer
	return source;
}

