#include <stdlib.h>
#include <stdio.h>
#include "bftape.h"

TAPE* createTapeCell(TAPE* prev, TAPE* next){
	TAPE* t = malloc(sizeof(TAPE));
	if(t==NULL) return NULL;
	
	t->cell=0;
	t->next=next;
	t->prev=prev;

	return t;	
}

void deleteTape(TAPE* aTape){
	if(aTape==NULL)return;
	TAPE* t = aTape;
	aTape=aTape->prev;
	//lösche das Band nach der aktuellen Stelle
	while(t->next != NULL){
		TAPE* next = t->next;
		free(t);
		t = next;
	}
	t = aTape;
	//lösche das Band vor der aktuellen Stelle
	while(t->prev != NULL){
		TAPE* prev = t->prev;
		free(t);
		t = prev;
	}
}

TAPE* getNextCell(TAPE* p){
	if(p->next == NULL){
		p->next = createTapeCell(p, NULL);
		if(p->next == NULL){
			fprintf(stderr, "Fehler: Speicherallokierung für Zelle fehlgeschlagen\n");
			exit(1);
		}
	}
	return p->next;
	
}
TAPE* getPrevCell(TAPE* n){
	if(n->prev == NULL){
		n->prev = createTapeCell(NULL, n);
		if(n->prev == NULL){
			fprintf(stderr, "Fehler: Speicherallokierung für Zelle fehlgeschlagen\n");
			exit(1);
		}
	}
	return n->prev;
}
