#include "extstring.h"
#include <string.h>
#include <stdlib.h>

extstring createExtstring(unsigned int size){
	extstring e;
	e.string=NULL;
	e.size=0;
	
	//reserviere Speicher
	e.string = malloc(size*sizeof(char));
	if(e.string!=NULL){
		e.size = size;
		e.string[0] ='\0';
	}
	return e;
}

void destroyExtstring(extstring* e){
	if(e->string != NULL)
		free(e->string);
}

char extendExtstring(extstring *es, unsigned int dsize){
	//zwischenspeicher für den erweiterten String
	extstring e = createExtstring(es->size+dsize);
	if(e.string==NULL)return 0;
	//kopiere den alten String in den neuen
	strcpy(e.string, es->string);
	//lösche den alten String
	destroyExtstring(es);
	//kopiere den neuen String an die Stelle des alten
	*es = e;
	return 1;
}

char appendChar(extstring *es, char c){
	unsigned int length = strlen(es->string);
	//ist der String groß genug, um ein weiteres Zeichen aufzunehmen?
	if(length+1<es->size){
		//erweitere den String (um mindestens 10, maximal 1000, und sonst die größe, die der String schon hat)
		unsigned int size = 10<length?length:10;
		size = size<1000?size:1000;
		if(!extendExtstring(es, size))return 0;
	}
	//füge das Zeichen hinzu
	es->string[length] = c;
	es->string[length+1] = 0;
	return 1;
}

char appendString(extstring *es, char* s){
	//ist der String groß genug?
	if(strlen(es->string)+strlen(s)<es->size){
		//erweitere den String, so dass genig Platz für da ist
		if(!extendExtstring(es, strlen(s)))return 0;
	}
	//Hänge den String an
	strcat(es->string, s);
	return 1;
}


