#include <stdio.h>
#include "brainfuck.h"
#include <errno.h>
#include <string.h>
#include "extstring.h"

int main(int argc, char** argv){
	FILE* f;
	if(argc >= 2){ 
		f = fopen(argv[1], "r");
		if(f==NULL){
			fprintf(stderr,"Fehler beim Lesen der Datei \"%s\": %s\n", argv[1], strerror(errno));
			return 1;
		}
	}
	else{
		f = stdin;
	}

	extstring code = createExtstring(500);
	
	int c;
	while((c=fgetc(f))!=EOF){
		appendChar(&code, c);
	}

	bf_interprete(code.string);
	destroyExtstring(&code);
	return 0;
}
