#ifndef POSITIONSTACK_H
#define POSITIONSTACK_H
//Einzelnes Element des Stacks, der die Positionen der geöffneten Klammern im COde speichert
typedef struct pstack_el{
	//Pointer auf die Stelle der geöffneten Klammer
	char *position;
	//nächstes (unteres) Element
	struct pstack_el *next;
}pstack_element;

//Ein Stack, der die Positionen der geöffneten Klammern im Code speichert
typedef struct pstack{
	//Oberes Ende des Stacks
	pstack_element *top;
}positionstack;

//Funktion, die einen neuen Stack erstellt
positionstack createStack();

/*Füge ein Element oben an den Stack an
Parameter: Stack, an den angefügt werden soll
Rückgabewert: false, wenn Speicherreservierung nicht erfolgreich war, top ist dann unverändert*/
char stackPush(positionstack* stack);

/*Entferne das oberste Element auf dem Stack 
 * Parameter: Stack, von dem das letzte Element gelöscht werden soll
 * Rückgabewert: fals, wenn der Stack leer ist, sonst true*/
char stackPop(positionstack* stack);

#endif
