#include <stdio.h>
#include <stdlib.h>
#include "bftape.h"
#include "extstring.h"
#include "positionstack.h"

char* get_closed_bracket(char* source);


void bf_interprete(char *code){
	TAPE* celltape;
	char *pos = code;
	//Stack für geöffnete Klammern
	positionstack stack = createStack();
	//Erstelle ein Tape
	celltape = createTapeCell(NULL, NULL);
	if(celltape == NULL){
		fprintf(stderr, "Fehler beim Speicherreservieren für das Tape\n");	
		exit(1);
	}
	while(*pos!=0){
		switch(*pos){
			case '+':
				celltape->cell++;
				break;
			case '-':
				celltape->cell--;
				break;
			case '<':
				celltape = getPrevCell(celltape);
				break;
			case '>':
				celltape = getNextCell(celltape);
				break;
			case '.':
				putchar(celltape->cell);
				break;
			case ',':
				celltape->cell = (char)getchar();
				break;
			case '[':{
				//Wenn der Wert auf dem Tape 0 ist, können wir direkt zur zugehörigen geschlossenen Klammer springen
				if(!celltape->cell){
					pos = get_closed_bracket(pos+1);
					break;
				}
				//versuche, die Position an den Stack zu hängen
				if(!stackPush(&stack)){
					fprintf(stderr, "Speicherreservierung fehlgeschlagen: positionstack");
					exit(1);
				}
				//speichere die Position nach dieser geschlossenen Klammer
				stack.top->position = pos;
				break;
			}
			case ']':
				//Wenn es keine Elemente auf dem Stack gibt, liegt ein Syntaxfehler vor
				if(stack.top == NULL){
					fprintf(stderr, "Syntaxfehler: fehlende geöffnete Klammer");
					exit(1);
				}
				//Gehe zurück zur passenden geschlossenen Klammer, wenn der Wert der Zelle != 0 ist
				if(celltape->cell){
					pos = stack.top->position;
				}
				//Wenn nicht, lösche das oberste Element des STacks
				else{
					stackPop(&stack);
				}
				break;
				
		}
		pos++;
	}
}

//Sucht zu einer geöffneten Klammer im BF-Code die passende geschlossene
//Rückgabewert: Position _nach_ der geschlossenen Klammer
char* get_closed_bracket(char* source){
	//Variable die speichert, wie viele offene Klammern es gibt
	int nopen=1;
	while(nopen>0){
		//Wenn das schon das Ende des Strings ist, liegt ein Syntaxfehler vor
		if(*source==0){
			fprintf(stderr, "Syntaxfehler: Schließende Klammer fehlt");
			exit(1);
		}
		//Zähle offene/geschlossene Klammern
		if(*source=='[')nopen++;
		else if(*source==']')nopen--;
		source++;
	}
	//Gebe zurück: Quellstring an der Stelle der geschlossenen Klammer
	return source-1;
}

