#ifndef EXTSTRING_H
#define EXTSTRING_H
//String, dessen Größe sich anpasst (wenn man die entsprechenden Funktionen verwendet
typedef struct{
	//Pointer auf den String
	char* string;
	//Größe des Feldes (nicht des Strings)
	unsigned int size;	
}extstring;

/*Erstelle einen solchen String
Parameter:
size: reservierte Länge
Rückgabewert: erweiterbarer String (extstring.string ist gleich NULL, wenn was schiefgegangen ist*/
extstring createExtstring(unsigned int size);
/*Zerstöre einen solchen String wieder
Parameter:
e: Pointer auf den freizumachenden String*/
void destroyExtstring(extstring* e);
/*Erweitere einen Extstring
Hierbei wird der bisher gespeicherte String in den neuen Speicherbereich kopiert.
Parameter:
es: Pointer auf den (initialisierten) zu erweiternden String
dsize: speichergröße, die hinzugefügt werden soll
Rückgabewert: !=0, wenn reservieren geklappt hat, sonst 0*/
char extendExtstring(extstring *e, unsigned int dsize);
/*Hänge ein Zeichen/einen String an den extstring an
hierbei wird ggf. der reservierte Speicher vergrößert.
Parameter:
es: pointer auf den (initialisierten) Extstring
s bzw. c: Anzuhängender String/ anzuhängendes Zeichen
Rückgabewert: !=0 wenn alles geklappt hat*/
char appendChar(extstring *es, char c);
char appendString(extstring *es, char* s);
#endif
