#include "ncsnake.h"
#include <stdlib.h>
#include <time.h>

void paint_snake(WINDOW *w, unsigned snakelength, const int* xpos, const int* ypos){
	unsigned u;
	mvwprintw(w, xpos[0], ypos[0], "x");
	for(u=1; u<snakelength; u++){
		mvwprintw(w, xpos[u], ypos[u], "X");
	}
}

void move_snake(unsigned snakelength, int *xpos, int *ypos, int xdir, int ydir){
	unsigned u;
	int xprev=xpos[0], yprev=ypos[0];
	xpos[0] = xprev+xdir;
	ypos[0] = yprev+ydir;

	for(u=1; u<snakelength; u++){
		int bufx = xprev, bufy = yprev;

		xprev = xpos[u];
		yprev = ypos[u];

		xpos[u] = bufx;
		ypos[u] = bufy;
	}
}

char collision_snake(unsigned snakelength, const int *xpos, const int *ypos, int xborder, int yborder){
	char collision = 0;
	refresh();
	unsigned n;
	for(n=0; n<snakelength; n++){
		collision = 	collision ||
				xpos[n] < 0 || xpos[n] >= xborder ||
				ypos[n] < 0 || ypos[n] >= yborder;
		if(collision) break;
		unsigned m;
		for(m=n+1; m<snakelength; m++){
			collision =	collision ||
					(xpos[m]==xpos[n] && ypos[m]==ypos[n]);
		}
	}
	return collision;
}

//platziert ein Stück Futter auf einem freien Platz
void place_food(unsigned snakelength, const int *sxpos, const int *sypos, int xborder, int yborder, int *foodx, int *foody){
	static char init = 0;
	char posgood = false;
	if(!init)
		srand(time(0));
	/*Ich benutze zum erstellen der Futterposition den "Kopf-durch-die-Wand"-Weg.
	Es ist daher möglich, dass nicht direkt beim ersten Mal eine freie Stelle für das Futter ausgesucht wurde.
	Das ist aber egal, da die andere Methode grob geschätzt in fast allen Fällen langsamer ist*/
	while(!posgood){
		*foodx=rand()%xborder;
		*foody=rand()%yborder;
		posgood=true;
		unsigned n;
		for(n=0; n<snakelength; n++){
			posgood = posgood && (*foodx != sxpos[n] || *foody != sypos[n]);
		}
	}
}
