#include <stdio.h>
#include "field.h"
#include "agent.h"
//----------
//Gibt das Spielfeld f aus, benutzt die Zeichen in c für die Darstellung 
void printField(ttt_field f, char *c){
	for(int m=0; m<TTT_FIELD_DIMENSION; m++){
		printf("+-+-+-+\n");
		printf("|");
		for(int n=0; n<TTT_FIELD_DIMENSION; n++){
			printf("%c|", c[f[m][n]]);
		}
		printf("\n");
	}
	printf("+-+-+-+\n");
}
//----------
//Fragt den Menschlichen Spieler, wohin er sein Zeichen setzen möchte
//p ist nicht die Spielernummer, sondern das Zeichen, das den Spieler repräsentiert
char* getUserAction(ttt_field f, char p){
	char *t = NULL;
	printf("Spieler %c\n", p);
	while(t==NULL){
		unsigned int x=0, y=0;
		printf("Bitte x- und y-Koordinate angeben (durch Leerzeichen getrennt).\n");
		scanf("%d", &x);
		scanf("%d", &y);
		//verschiebe die Koordinaten, um auf das Array zuzugreifen
		x--; y--;
		if(x<3 && y<3 && f[y][x] == 0)t=&f[y][x];
		else printf("Eingabe ungueltig\n");
	}
	return t;
}
//----------
//Spielt das Spiel einmal durch
void ttt_game(){
	//Leeres Feld
	ttt_field f = {	{0,0,0},
			{0,0,0},
			{0,0,0}};
	//Standardmäßige Darstellung
	char pres[] = {' ', 'X', 'O'};

			printField(f, pres);
			//Starte bei Spieler 1
			char curPlayer=1;
			//Spiele so lange, bis das Spiel zu Ende ist
			char winner=0;
			while(!(winner=isFinite(f))){
				printf("Spieler %c ist am Zug\n", pres[curPlayer]);
				char *decision = NULL;
				switch(curPlayer){
					case 1:
						decision=getUserAction(f, pres[curPlayer]);
						break;
					case 2:
						decision = whatWouldAgentDo(f, curPlayer);
						break;
				}
				if(decision != NULL) *decision = curPlayer;
				curPlayer= curPlayer==1?2:1;
				printField(f, pres);
			}
			switch(winner){
				case 1:
					printf("What about a nice game of chess?\n");
					break;
				case 2:
					printf("Where is the difference?\n");
					break;
				case 3:
					printf("A strange Game. The only winnig move is not to play.\n");
			}
		}
		//----------
