#include "field.h"

//----------
//rotiere das Spielfeld um 90° im Uhrzeigersinn
void ttt_rotateField(ttt_field f){
	//zwischenspeicher für das Ergebnis
	ttt_field buff;
	for(int m=-1; m<TTT_FIELD_DIMENSION-1; m++){
		for(int n=-1; n<TTT_FIELD_DIMENSION-1; n++){
			/*Rotationsmatrix:
			(0  1)
			(-1 0)*/
			buff[n+1][-1*m+1] = f[m+1][n+1];
		}
	}
	//Kopiere nun die alte Matrix in die neue
	for(int m=0; m<TTT_FIELD_DIMENSION; m++){
		for(int n=0; n<TTT_FIELD_DIMENSION; n++){
			f[m][n] = buff[m][n];
		}
	}
}
//----------
//Spiegle das Spielfeld an der senkrechten Mittelachse
void ttt_flipField(ttt_field f){
	//buffervariable
	char b=0;
	for(int i=0; i<TTT_FIELD_DIMENSION; i++){
		//Tausche das Feld rechts mit dem Feld links
		b = f[i][0];
		f[i][0] = f[i][2];
		f[i][2] = b;
	}
}
//----------
//Zählt die Anzahl der noch freien Felder
char freeFields(ttt_field f){
	char c = 0;
	for(unsigned i=0; i<TTT_FIELD_DIMENSION; i++){
		for(unsigned j=0; j<TTT_FIELD_DIMENSION; j++){
			if(f[i][j] == 0) c++;
		}
	}
	return c;
}
//----------
//Schaut nach, ob das Spiel beendet ist
/*Rückgabewert: 0, wenn noch nicht beendet
		1 oder 2, wenn ein Spieler gewonnen hat
		3 bei untenschieden*/
char isFinite(ttt_field f){
	//Für jeden Spieler, überprüfe ob er gewonnen hat
	//Of course, there are more ways than this to do it
	for(char p=1; p<=2; p++){
		//Zähler für die Diagonalen
		char d1counter=0, d2counter=0;
		for(char i=0; i<TTT_FIELD_DIMENSION; i++){
			//Zähler für die Reihen und Spalten
			char hcounter=0, vcounter=0;
			for(char j=0; j<TTT_FIELD_DIMENSION; j++){
				//Zähle die Spalten und Reihen
				if(f[i][j]==p) hcounter++;
				if(f[j][i]==p) vcounter++;
			}
			//überprüfe, ob der Spieler in dieser Reihe/Spalte gewonnen hat
			if(hcounter==3 || vcounter==3)return p;
			//Zähle die Diagonalen
			if(f[i][i]==p) d1counter++;
			if(f[i][2-i]==p) d2counter++;
		}
		//Überprüfe, ob dieser Spieler in einer Diagonalen gewonnen hat
		if(d1counter==3 || d2counter==3) return p;
	}
	//Nun gebe zurück, ob das Spiel noch weitergeht oder unentschieden ist
	return freeFields(f)==0?3:0;
}
//----------
