#include "field.h"
#include <stdlib.h>
#include <stdio.h>
//----------
/*Kann Spieler p im nächsten Zug gewinnen?
Rückgabewert: Nullpointer wenn nicht, sonst Pointer auf das(bzw ein) Feld,
das Gewinn bringt*/
char * canWin(ttt_field f, unsigned p){
	char d1counter=0, d2counter=0;
	char  *d1win=NULL, *d2win=NULL;
	//überprüfe Reihen, Spalten und Diagonalen
	for(unsigned i=0; i<TTT_FIELD_DIMENSION; i++){
		char hcounter=0, vcounter=0;
		char *hfwin = NULL, *vfwin = NULL;
		//Zähle die einzelnen Elemente der Reihen/Spalten durch
		for(unsigned j=0; j<TTT_FIELD_DIMENSION; j++){
			//Zähle die Felder, in denen Spieler p sein Zeichen hat
			if(f[i][j] == p) hcounter++;
			//Wenn das Feld noch frei ist, setze temporär den Zeiger
			else if(f[i][j] == 0)hfwin = &f[i][j];
			//das ganze jetzt noch für die Spalten
			if(f[j][i] == p) vcounter++;
			else if(f[j][i] == 0)vfwin = &f[j][i];
		}
		//Für die Diagonalen brauchen wir nur die eine Schleife
		if(f[i][i] == p) d1counter++;
		else if (f[i][i] == 0) d1win=&f[i][i];
		if(f[i][2-i] == p) d2counter++;
		else if(f[i][2-i] == 0)d2win=&f[i][2-i];
		//Nur wenn genau zwei Felder der Reihe besetzt sind und das dritte nicht von dem anderen Spieler, kann p im nächsten Zug gewinnen
		if(hcounter==TTT_FIELD_DIMENSION-1 && hfwin != NULL)return hfwin;
		else if(vcounter==TTT_FIELD_DIMENSION-1 && vfwin != NULL)return vfwin;
	}
	//Gleiche Siegbedingung wie in der Schleife, nur hier für die Diagonalen
	if(d1counter==TTT_FIELD_DIMENSION-1 && d1win != NULL)return d1win;
	else if(d2counter==TTT_FIELD_DIMENSION-1 && d2win != NULL)return d2win;

	return NULL;
}
/*Finde einen guten Platz, das Zeichen zu setzen:
Priorität: Mitte, Ecken, Seiten
Note to self: Noch eventuell verbessern, so dass 2-er Linien gebildet werden
sonst wird p auch noch garnicht gebraucht...*/
char * findGoodPlace(ttt_field f, unsigned p){
	if(f[1][1]==0)return &f[1][1];
	//Oh, eine Sonderregel: Wenn der Gegner bei sechs freien Feldern zwei gegenüberliegende Ecken besetzt hat (laut dieser Policy hat der Computer dann den Mittelpunkt belegt), vergiss die Sache mit den Ecken
	char p2=p==1?2:1;
	if(!(freeFields(f)==6 &&
		((f[0][2] == p2 && f[2][0] == p2) ||
		(f[0][0] == p2 && f[2][2] == p2)))){
		//So, und jetzt die Ecken
		for(char i=0; i<2; i++){
			for(char j=0; j<2; j++){
				//i*2 ist hier entweder 2 oder 0, also das, was ich brauche
				if(f[i*2][j*2]==0)return &f[i*2][j*2];
			}
		}
	}
	//jetzt die Kanten. Die konnte ich leider nicht in dieselbe Schleife packen...
	char ind[4][2] = {{0,1},{1,0},{1,2},{2,1}};
	for(char i=0; i<4; i++){
		char * tmp;
		if(*(tmp=&f[ind[i][0]][ind[i][1]]) == 0)return tmp;
	}
	return NULL;
}
//----------
char * whatWouldAgentDo(ttt_field f, unsigned p){
	char * result;
	//Nummer des anderen Spielers
	unsigned p2;
	//Wenn p=0 oder p>2 ist der Wert nicht korrekt, gebe Fehler zurück
	if(p==0 || p>2)return NULL;
	//Ebenso, wenn es keine freien Felder mehr gibt
	if(freeFields(f)==0)return NULL;
	//Setze p2 als den jeweils anderen Spieler
	p2 = p==1?2:1;
	
	//So, jetzt bitte nacheinander alle Möglichkeiten durchgehen
	//Wenn das Spiel in dieser Runde gewonnen werden kann, dann gewinne
	if((result=canWin(f, p))!=NULL)return result;
	//Wenn der Gegner im nächsten Zug das Spiel gewinnen kann, verhindere dies (wenn möglich)
	if((result=canWin(f, p2))!=NULL)return result;
	//Wenn nicht, suche die einen guten freien Platz, um das Zeichen zu setzen
	return findGoodPlace(f, p);
}
//----------
